/** @file   particlemanager.h
 * @brief   Declaration of ParticleManager - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_ENG2D_PARTICLEMANAGER_H
#define H_ENG2D_PARTICLEMANAGER_H

#include "eng2d_dll.h"
#include "interactive.h"
#include <vector>
#include "particlesystem.h"


namespace eng2d {

/** @class  ParticleManager
 * @brief   Manages the activated ParticleSystems.
 * @author  Tomi Lamminsaari
 *
 * This updates and draws the instances of the ParticleSystem class. Once every
 * particle of a ParticleSystem has died, we delete the ParticleSystem itself.
 */
class DLLIMPORT ParticleManager : public Interactive
{
public:

  ///
  /// Constants, datatype and static members
  /// ======================================


  ///
  /// Constructors, destructor and operators
  /// ======================================

	/** Constructor.
   */
	ParticleManager();


	/** Destructor
   */
	virtual ~ParticleManager();

private:

	/** Copy constructor.
   * @param     rO                Reference to another ParticleManager
   */
  ParticleManager( const ParticleManager& rO );

	/** Assignment operator
   * @param     rO                Reference to another ParticleManager
   * @return    Reference to us.
   */
  ParticleManager& operator = ( const ParticleManager& rO );

public:



  ///
  /// Methods
  /// =======

  /** Adds new ParticleSystem.
   * @param     pPS               Pointer to ParticleSystem
   */
  virtual void addSystem( ParticleSystem* pPS );

  /** Updates the particle systems
   */
  virtual void update();
  
  /** Destroys all the particle systems.
   */
  virtual void clear();
  
  /** Redraws all the ParticleSystems.
   * @param     pB                Pointer to target bitmap.
   * @param     offset            Offset to translate the world-coordinates
   *                              to screen coordinates.
   */
  virtual void redraw( BITMAP* pB, const Vec2D& offset ) const;
  

  ///
  /// Getter methods
  /// ==============
  
  /** Returns the number of ParticleSystems there are.
   * @return    Number of active ParticleSystems
   */
  virtual int systemCount() const;


protected:

  ///
  /// Members
  /// =======

  /** All the ParticleSystems this manager manages. */
  std::vector< ParticleSystem* >  m_particleSystems;


private:

  ///
  /// Private members
  /// ===============

};

};  // end of namespace

#endif
